﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Data;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using DataAccess;

/// <summary>
/// Patient lock methods and properties
/// </summary>
public class CPatientLock
{
    /// <summary>
    /// BaseMaster property
    /// </summary>
    protected BaseMaster m_BaseMstr;
    
    /// <summary>
    /// Constructor takes a BaseMaster
    /// </summary>
    /// <param name="BaseMstr"></param>
    public CPatientLock(BaseMaster BaseMstr)
	{
        m_BaseMstr = BaseMstr;
    }

    /// <summary>
    /// Refresh patient lock
    /// </summary>
    /// <param name="strPatientID"></param>
    /// <returns></returns>
    public bool RefreshPatientLock(string strPatientID)
    {
        //status info
        long lStatusCode = 0;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList pList = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        pList.AddInputParameter("pi_vPatientID", strPatientID);

        //Execute Oracle stored procedure
        m_BaseMstr.DBConn.ExecuteOracleSP("PCK_PATIENT_LOCK.RefreshPatientLock",
                                        pList,
                                        out lStatusCode,
                                        out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;

        if (lStatusCode == 0)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    /// <summary>
    /// Get patient lock
    /// </summary>
    /// <param name="strPatientID"></param>
    /// <returns></returns>
    protected DataSet GetPatientLock(string strPatientID) 
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList pList = new CDataParameterList(m_BaseMstr.ASPSessionID, m_BaseMstr.ClientIP, m_BaseMstr.FXUserID);

        pList.AddInputParameter("pi_vPatientID", strPatientID);

        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                           "PCK_PATIENT_LOCK.GetPatientLock",
                                            pList,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;

        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// Is patient locked
    /// </summary>
    /// <param name="strPatientID"></param>
    /// <param name="strProviderName"></param>
    /// <param name="strProviderEmail"></param>
    /// <returns></returns>
    public bool IsPatientLocked(string strPatientID, out string strProviderName, out string strProviderEmail) 
    {
        strProviderName = String.Empty;
        strProviderEmail = String.Empty;
        DataSet ds = this.GetPatientLock(strPatientID);
        if (ds != null)
        {
            if (ds.Tables[0].Rows.Count > 0)
            {
                bool bLocked = true;
                foreach (DataTable dt in ds.Tables) 
                {
                    foreach (DataRow dr in dt.Rows) 
                    { 
                        if(dr["PATIENT_ID"].ToString() == strPatientID)
                        {
                            if (Convert.ToInt32(dr["FX_USER_ID"]) == m_BaseMstr.FXUserID)
                            {
                                bLocked = false;
                            }
                            strProviderName = dr["PROVIDER_NAME"].ToString();
                            strProviderEmail = dr["EMAIL"].ToString();
                        }
                    }
                }
                return bLocked;
            }
            else
            {
                //insert lock record
                this.InsertPatientLock(strPatientID);
                return false;
            }
        }
        else
        {
            //insert lock record
            this.InsertPatientLock(strPatientID);
            return false;
        }
    }

    /// <summary>
    /// Insert patient lock
    /// </summary>
    /// <param name="strPatientID"></param>
    /// <returns></returns>
    public bool InsertPatientLock(string strPatientID)
    {
        //status info
        long lStatusCode = 0;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList pList = new CDataParameterList(m_BaseMstr.ASPSessionID, m_BaseMstr.ClientIP, m_BaseMstr.FXUserID);

        pList.AddInputParameter("pi_vPatientID", strPatientID);

        //Execute Oracle stored procedure
        m_BaseMstr.DBConn.ExecuteOracleSP("PCK_PATIENT_LOCK.InsertPatientLock",
                                        pList,
                                        out lStatusCode,
                                        out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;

        if (lStatusCode == 0)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    /// <summary>
    /// Delete patient lock
    /// </summary>
    /// <param name="strPatientID"></param>
    /// <returns></returns>
    public bool DeletePatientLock(string strPatientID)
    {
        //status info
        long lStatusCode = 0;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList pList = new CDataParameterList(m_BaseMstr.ASPSessionID, m_BaseMstr.ClientIP, m_BaseMstr.FXUserID);

        pList.AddInputParameter("pi_vPatientID", strPatientID);

        //Execute Oracle stored procedure
        m_BaseMstr.DBConn.ExecuteOracleSP("PCK_PATIENT_LOCK.DeletePatientLock",
                                        pList,
                                        out lStatusCode,
                                        out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;

        if (lStatusCode == 0)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

}
